import React, { useState } from "react";
import Tabs from "./Tabs";

export default function ResponsePanel({ response }) {
  const [activeTab, setActiveTab] = useState("body");

  if (!response) {
    return (
      <div className="h-full flex items-center justify-center text-gray-500 text-sm bg-gray-900/50">
        Enter a URL and click Send to get a response.
      </div>
    );
  }

  const tabs = [
    { id: "body", label: "Body" },
    { id: "headers", label: "Headers" },
  ];

  // Helper to safely format JSON
  const formattedBody =
    typeof response.body === "string"
      ? response.body
      : JSON.stringify(response.body, null, 2);

  // Allow passing status specifically if available, otherwise assume 200/Error based on data (App.jsx logic handles this loosely currently)
  // Current App.jsx sets response to `res.data` or error data.
  // It effectively loses the status code unless I update App.jsx.
  // For now I'll just show the body.

  return (
    <div className="flex flex-col h-full border-t border-gray-800 bg-gray-900">
      <div className="flex items-center justify-between px-4 py-2 border-b border-gray-800 bg-gray-900">
        <div className="text-sm font-semibold text-gray-400">Response</div>
        <div className="flex gap-4 text-xs">
          {/* Placeholder for status/time as they aren't fully passed yet */}
          <span className="text-gray-500">
            Status: <span className="text-green-500">{response.status} </span>
          </span>
          <span className="text-gray-500">
            Time: <span className="text-white">{response.time} ms</span>
          </span>
          <span className="text-gray-500">
            Size: <span className="text-white">{response.size} KB</span>
          </span>
        </div>
      </div>

      <Tabs tabs={tabs} activeTab={activeTab} onTabChange={setActiveTab} />

      <div className="flex-1 p-4 overflow-auto custom-scrollbar">
        {activeTab === "body" && (
          <pre className="text-xs font-mono text-green-300 whitespace-pre-wrap break-all">
            {formattedBody}
          </pre>
        )}
        {activeTab === "headers" && (
          <div className="text-gray-500 text-center mt-4 text-sm">
            Response headers not available yet.
          </div>
        )}
      </div>
    </div>
  );
}
